const { contextBridge, ipcRenderer } = require("electron");
const os = require("os");

const getIps = (cb) => {
    let ips = [];
    var interfaces = os.networkInterfaces();
    for (var k in interfaces) {
        for (var k2 in interfaces[k]) {
            var address = interfaces[k][k2];
            if (address.family === 'IPv4' && !address.internal) {
                //ipDiv.innerHTML += `${address.address}<br/>\n`;
                console.log(address.address);
                ips.push(address.address);
            }
        }
    }
    cb(null,ips);
}

const validChannels = [ 'chooseFtpDirectory'];

contextBridge.exposeInMainWorld("api", {
    getIps,
    handleLg: (callback) => ipcRenderer.on('handleLg', callback),
    invokeIpc: (channel, args) => {
        if (validChannels.includes(channel)) {
            return ipcRenderer.invoke(channel, args);
        } else {
            console.error(`Error: tried to invoke non-white-listed channel: `,channel);
        }
    }
});

